"use client"

interface CasinoStatsProps {
  results: string[]
  userVotes: Record<number, string>
}

export default function CasinoStats({ results, userVotes }: CasinoStatsProps) {
  const calculateUserScore = () => {
    let correct = 0
    let total = 0

    Object.entries(userVotes).forEach(([round, vote]) => {
      const roundIndex = Number.parseInt(round) - 1
      if (results[roundIndex]) {
        total++
        const result = results[roundIndex]
        if ((vote === "heads" && result === "H") || (vote === "tails" && result === "T")) {
          correct++
        }
      }
    })

    return { correct, total }
  }

  const { correct, total } = calculateUserScore()
  const accuracy = total > 0 ? Math.round((correct / total) * 100) : 0

  return (
    <div className="bg-gray-800 border-2 border-gray-600 rounded-lg p-4">
      <h3 className="text-lg font-bold mb-4 text-center">Session Stats</h3>

      <div className="space-y-3">
        <div className="flex justify-between">
          <span className="text-gray-300">Correct Guesses:</span>
          <span className="font-bold text-green-400">{correct}</span>
        </div>

        <div className="flex justify-between">
          <span className="text-gray-300">Total Guesses:</span>
          <span className="font-bold">{total}</span>
        </div>

        <div className="flex justify-between">
          <span className="text-gray-300">Accuracy:</span>
          <span className="font-bold text-blue-400">{accuracy}%</span>
        </div>

        <div className="border-t border-gray-600 pt-3">
          <div className="flex justify-between">
            <span className="text-gray-300">Total Session Score:</span>
            <span className="font-bold text-yellow-400">{correct}</span>
          </div>
        </div>
      </div>

      <div className="mt-4 p-3 bg-blue-900 border border-blue-600 rounded">
        <div className="text-xs text-blue-200 text-center">
          Scores are tracked throughout your session. Keep playing to improve your accuracy!
        </div>
      </div>
    </div>
  )
}
