"use client";

interface PercentageBarProps {
  playerPercentage: number;
  bankerPercentage: number;
  tiePercentage: number;
  currentHand?: number;
  totalHands?: number;
}

export default function PercentageBar({
  playerPercentage,
  bankerPercentage,
  tiePercentage,
  currentHand,
  totalHands,
}: PercentageBarProps) {
  return (
    <div
      className="flex items-center gap-2 sm:gap-4 md:gap-8 p-2 sm:p-3 md:p-4 rounded-lg"
      style={{
        backgroundImage: "url('/images/bg-5.jpg')",
        backgroundSize: "cover",
        backgroundPosition: "center",
      }}
    >
      {/* Percentage Bar Container */}
      <div className="relative flex-1 h-10 sm:h-12 md:h-14 rounded-full overflow-hidden flex shadow-inner">
        {/* Player (Red) */}
        {playerPercentage > 0 && (
          <div
            className="h-full flex items-center justify-center text-white font-impact text-sm sm:text-base md:text-lg lg:text-xl"
            style={{
              width: `${playerPercentage}%`,
              background:
                "linear-gradient(to bottom, #ff3b3b 50%, #ff0000 50%)",
              borderTopLeftRadius: "9999px",
              borderBottomLeftRadius: "9999px",
            }}
          >
            {playerPercentage > 0 && `${playerPercentage}%`}
          </div>
        )}

        {/* Banker (Blue) */}
        {bankerPercentage > 0 && (
          <div
            className="h-full flex items-center justify-center text-white font-impact text-sm sm:text-base md:text-lg lg:text-xl"
            style={{
              width: `${bankerPercentage}%`,
              background:
                "linear-gradient(to bottom, #3b62ff 50%, #0033ff 50%)",
            }}
          >
            {bankerPercentage > 0 && `${bankerPercentage}%`}
          </div>
        )}

        {/* Tie (Green) */}
        {tiePercentage > 0 && (
          <div
            className="h-full flex items-center justify-center text-white font-impact text-sm sm:text-base md:text-lg lg:text-xl"
            style={{
              width: `${Math.max(tiePercentage, 10)}%`,
              background:
                "linear-gradient(to bottom, #3bd83b 50%, #00cc00 50%)",
              borderTopRightRadius: "9999px",
              borderBottomRightRadius: "9999px",
            }}
          >
            {tiePercentage > 0 && `${tiePercentage}%`}
          </div>
        )}
      </div>

      {/* Hand Counter */}
      <div className="text-white font-black text-[3.2vw] sm:text-base md:text-lg lg:text-xl tracking-wider text-shadow-sm font-impact">
        Hand {currentHand} of {totalHands}
      </div>
    </div>
  );
}
