"use client";

interface VotingInterfaceProps {
  correct: number;
  incorrect: number;
  sessionScore: number;
  disabled: boolean;
  onSubmitVote: (vote: "PLAYER" | "BANKER") => void;
}

export default function VotingInterface({
  correct,
  incorrect,
  sessionScore,
  disabled,
  onSubmitVote,
}: VotingInterfaceProps) {
  return (
    <div className=" h-full">
      <div className=" grid grid-cols-2 gap-0 mb-0">
        {/* Player Button */}
        <button
          disabled={disabled}
          onClick={() => onSubmitVote("PLAYER")}
          className={`h-30 px-4 py-2 border-4 border-yellow-500  shadow-lg flex items-center justify-center transition-all duration-200
      ${
        disabled
          ? "bg-[#4a0f0d] text-opacity-50 grayscale cursor-not-allowed"
          : "bg-[#7b1d17] hover:bg-red-500 hover:scale-105 cursor-pointer"
      }`}
        >
          <span
            className="text-xl md:text-2xl font-impact tracking-wider text-[#fe0000] text-shadow-sm"
            style={{
              opacity: disabled ? 0.5 : 1,
              filter: disabled ? "grayscale(100%)" : "none",
            }}
          >
            PLAYER
          </span>
        </button>

        {/* Banker Button */}
        <button
          disabled={disabled}
          onClick={() => onSubmitVote("BANKER")}
          className={`h-30 px-4 py-2 border-4 border-yellow-500  shadow-lg flex items-center justify-center transition-all duration-200
      ${
        disabled
          ? "bg-[#4a0f0d] text-opacity-50 grayscale cursor-not-allowed"
          : "bg-[#7b1d17] hover:bg-red-600 hover:scale-105 cursor-pointer"
      }`}
        >
          <span
            className=" text-xl md:text-2xl font-impact tracking-wider text-yellow-400 text-shadow-sm"
            style={{
              opacity: disabled ? 0.5 : 1,
              filter: disabled ? "grayscale(100%)" : "none",
            }}
          >
            BANKER
          </span>
        </button>
      </div>
      <div className="bg-[#edc895] p-1  h-full md:p-2 flex sm:gap-x-6 text-black text-base justify-center gap-2 sm:gap-0">
        {/* Left column for guess labels and counts */}
        <div className=" h-fit font-poppins ">
          <div className="flex justify-between items-center gap-2">
            <span className=" text-[3.2vw] sm:text-lg font-medium">Wins</span>
            <span className="text-[3.2vw] sm:text-lg md:text-xl lg:text-2xl font-impact leading-none">
              {correct}
            </span>
          </div>
          <div className="flex justify-between items-center gap-2">
            <span className=" text-[3.2vw] sm:text-lg md:text-lg font-medium">
              Losses
            </span>
            <span className="text-[3.2vw] sm:text-lg md:text-xl lg:text-2xl font-impact leading-none">
              {incorrect}
            </span>
          </div>
        </div>

        {/* Right column for Total Session Score */}
        <div className="col-span-2 flex-col items-center justify-center flex h-fit ml-3">
          <div>
            <span className=" text-[2vw] sm:text-sm font-poppins font-medium">
              Total Session Score
            </span>
          </div>
          <span className="text-xl sm:text-2xl md:text-4xl lg:text-5xl font-impact leading-none">
            {sessionScore}
          </span>
        </div>
      </div>
    </div>
  );
}
