"use client";

import { useState, useEffect } from "react";

export function useTimers(
  roundStartTime: number | null,
  bettingDurationSeconds: number | null
) {
  const [elapsedTime, setElapsedTime] = useState(0);
  const [bettingCountdown, setBettingCountdown] = useState<number | null>(null);

  useEffect(() => {
    if (roundStartTime) {
      const updateElapsed = () => {
        const now = Date.now();
        const elapsed = Math.max(0, (now - (roundStartTime || now)) / 1000);
        setElapsedTime(parseFloat(elapsed.toFixed(1)));
      };

      updateElapsed();
      const interval = setInterval(updateElapsed, 100);
      return () => clearInterval(interval);
    } else {
      setElapsedTime(0);
    }
  }, [roundStartTime]);

  useEffect(() => {
    if (roundStartTime && bettingDurationSeconds) {
      const updateCountdown = () => {
        const now = Date.now();
        const elapsedSeconds = (now - roundStartTime!) / 1000;
        const remaining = Math.max(0, bettingDurationSeconds! - elapsedSeconds);
        setBettingCountdown(remaining);
      };

      updateCountdown();
      const interval = setInterval(updateCountdown, 1000);

      return () => clearInterval(interval);
    } else {
      setBettingCountdown(null);
    }
  }, [roundStartTime, bettingDurationSeconds]);

  return { elapsedTime, bettingCountdown };
}
